PACKAGE p_attr IS    
  TYPE t_package_type IS ( leadless, 
                           pin_grid, 
                           dip);    

  ATTRIBUTE package_type : t_package_type;    
  ATTRIBUTE location : INTEGER;
 
END p_attr; 

USE WORK.p_attr.ALL; 
ENTITY board IS    
  PORT(  y : in bit 
         --            
         --            
         --   
             ); 
END board; 

ARCHITECTURE cpu_board OF board IS    
  COMPONENT mc68040         
    GENERIC(  x:time);        
    PORT(   z : bit
            --               
            --               
            --    
                );    
  END COMPONENT;    
  SIGNAL a : INTEGER;
  SIGNAL b : t_package_type;
   
  ATTRIBUTE package_type OF mc68040 : COMPONENT IS pin_grid;
   
  ATTRIBUTE location OF mc68040 : COMPONENT IS 20; 
BEGIN    
  a <= mc68040'location;  
  -- returns 20 
  
  b <= mc68040'package_type; 
  -- returns pin_grid
 
END cpu_board;

